$(document).ready(function() {

  "use strict"; 

  	jQuery("#contactForm").validator().on("submit", function (event) {

		"use strict";

		if (event.isDefaultPrevented()) {
			// handle the invalid form...
			formError();
			submitMSG(false, "Please Follow Error Messages and Complete as Required");
		} else {
			// everything looks good!
			event.preventDefault();
			submitForm();
		}
	});

	function submitForm(){
		
		"use strict";

		// Initiate Variables With Form Content
		var txtname = $("#txtname").val();
		var txtemail = $("#txtemail").val();
		var txtmessage = $("#txtmessage").val();

		$.ajax({
			type: "POST",
			url: "php/form-process.php",
			data: "txtname=" + txtname + "&txtemail=" + txtemail + "&txtmessage=" + txtmessage,
			success : function(text){
				if (text == "success"){
					formSuccess();
				} else {
					formError();
					submitMSG(false,text);
				}
			}
		});
	}

	function formSuccess(){
		
		"use strict";

		$("#contactForm")[0].reset();
		submitMSG(true, "Thank you for your submission :)")
	}

	function formError(){
		
		"use strict";

		$("#contactForm").removeClass().addClass('shake animated').one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function(){
			$(this).removeClass();
		});
	}

	function submitMSG(valid, msg){
		
		"use strict";

		if(valid){
			var msgClasses = "success form-message";
		} else {
			var msgClasses = "error form-message";
		}
		$("#msgSubmit").removeClass().addClass(msgClasses).text(msg);
	}

	initSlickCarousel();
	// slick init
	function initSlickCarousel() {
		jQuery('.slick-fade').slick({
			slidesToScroll: 1,
			rows: 0,
			prevArrow: '<a href="#" class="slick-prev"><i class="fi flaticon-back"></i><span class="sr-only">Previous</span></a>',
			nextArrow: '<a href="#" class="slick-next"><i class="fi flaticon-right-arrow"></i><span class="sr-only">Next</span></a>',
			fade: true,
			dots: false,
			arrows: true,
			adaptiveHeight: true,
			speed: 1500,
			responsive: [
				{
					breakpoint: 768,
					settings: {
						dots: true,
						arrows: false
					}
				}
			]
		});

		jQuery('.slick-fade2').slick({
			slidesToScroll: 1,
			rows: 0,
			prevArrow: '<a href="#" class="slick-prev"><i class="fi flaticon-arrows-1 readMoreIcn"></i><span class="sr-only">Previous</span></a>',
			nextArrow: '<a href="#" class="slick-next"><i class="fi flaticon-arrows readMoreIcn"></i><span class="sr-only">Next</span></a>',
			fade: true,
			dots: false,
			arrows: true,
			adaptiveHeight: true,
			speed: 1500,
			responsive: [
				{
					breakpoint: 768,
					settings: {
						dots: true,
						arrows: false
					}
				}
			]
		});

		jQuery('.slick-carousel').slick({
			slidesToScroll: 1,
			rows: 0,
			prevArrow: '<a href="#" class="slick-prev"><i class="fi flaticon-back"></i><span class="sr-only">Previous</span></a>',
			nextArrow: '<a href="#" class="slick-next"><i class="fi flaticon-right-arrow"></i><span class="sr-only">Next</span></a>',
			adaptiveHeight: true,
			speed: 800
		});

		$('.slick-thumbnailslider').slick({
		  slidesToShow: 1,
		  slidesToScroll: 1,
		  arrows: true,
		  prevArrow: '<a href="#" class="slick-prev"><i class="fi flaticon-back"></i><span class="sr-only">Previous</span></a>',
		  nextArrow: '<a href="#" class="slick-next"><i class="fi flaticon-right-arrow"></i><span class="sr-only">Next</span></a>',
		  fade: true,
		  asNavFor: '.slick-carouselnav'
		});
		$('.slick-carouselnav').slick({
		  slidesToShow: 6,
		  slidesToScroll: 1,
		  asNavFor: '.slick-thumbnailslider',
		  dots: false,	  
		  arrows: false,
		  centerMode: true,
		  focusOnSelect: true
		});

		jQuery('.four-slider').slick({
			slidesToScroll: 1,
			rows: 0,
			slidesToShow: 4,
			prevArrow: '<a href="#" class="slick-prev"><i class="fi flaticon-back"></i><span class="sr-only">Previous</span></a>',
			nextArrow: '<a href="#" class="slick-next"><i class="fi flaticon-right-arrow"></i><span class="sr-only">Next</span></a>',
			adaptiveHeight: true,
			speed: 800,

			responsive: [{
				breakpoint: 1199,
				settings: {
					slidesToShow: 3
				}
			}, {
				breakpoint: 991,
				settings: {
					slidesToShow: 2
				}
			}, {
				breakpoint: 639,
				settings: {
					slidesToShow: 1
				}
			}, {
				breakpoint: 575,
				settings: {
					slidesToShow: 1,
					dots: true,
					arrows: false
				}
			}]
		});

		jQuery('.profilesSlider2').slick({
			slidesToScroll: 1,
			rows: 0,
			slidesToShow: 4,
			prevArrow: '<a href="#" class="slick-prev"><i class="fi flaticon-arrows-1 readMoreIcn"></i><span class="sr-only">Previous</span></a>',
			nextArrow: '<a href="#" class="slick-next"><i class="fi flaticon-arrows readMoreIcn"></i><span class="sr-only">Next</span></a>',
			adaptiveHeight: true,
			speed: 800,

			responsive: [{
				breakpoint: 1199,
				settings: {
					slidesToShow: 3
				}
			}, {
				breakpoint: 991,
				settings: {
					slidesToShow: 2
				}
			}, {
				breakpoint: 639,
				settings: {
					slidesToShow: 1
				}
			}, {
				breakpoint: 575,
				settings: {
					slidesToShow: 1,
					dots: true,
					arrows: false
				}
			}]
		});

		jQuery('.three-slider').slick({
			slidesToScroll: 1,
			rows: 0,
			slidesToShow: 3,
			prevArrow: '<a href="#" class="slick-prev"><i class="fi flaticon-arrows-1 readMoreIcn"></i><span class="sr-only">Previous</span></a>',
			nextArrow: '<a href="#" class="slick-next"><i class="fi flaticon-arrows readMoreIcn"></i><span class="sr-only">Next</span></a>',
			adaptiveHeight: true,
			dots: false,
			arrows: true,
			speed: 800,

			responsive: [
			{
				breakpoint: 991,
				settings: {
					slidesToShow: 2
				}
			}, {
				breakpoint: 639,
				settings: {
					slidesToShow: 1
				}
			}, {
				breakpoint: 575,
				settings: {
					slidesToShow: 1,
					arrows: false
				}
			}]
		});
		jQuery('.banner-slider').slick({
			slidesToScroll: 1,
			rows: 0,
			slidesToShow: 3,
			prevArrow: '<a href="#" class="slick-prev"><i class="fi flaticon-arrows-1 readMoreIcn"></i><span class="sr-only">Previous</span></a>',
			nextArrow: '<a href="#" class="slick-next"><i class="fi flaticon-arrows readMoreIcn"></i><span class="sr-only">Next</span></a>',
			adaptiveHeight: true,
			dots: false,
			arrows: true,
			speed: 800,

			responsive: [
			{
				breakpoint: 991,
				settings: {
					slidesToShow: 2
				}
			}, {
				breakpoint: 639,
				settings: {
					slidesToShow: 1
				}
			}, {
				breakpoint: 575,
				settings: {
					slidesToShow: 1,
					arrows: false
				}
			}]
		});

		jQuery('.testimonial-carousel').slick({
			slidesToScroll: 1,
			rows: 0,
			slidesToShow: 1,
			arrows: false,
			dots: true,
			adaptiveHeight: true,
			speed: 800
		});

		jQuery('.testimonial-carousel2').slick({
			slidesToScroll: 1,
			rows: 0,
			prevArrow: '<a href="#" class="slick-prev"><i class="fi flaticon-arrows-1 readMoreIcn"></i><span class="sr-only">Previous</span></a>',
			nextArrow: '<a href="#" class="slick-next"><i class="fi flaticon-arrows readMoreIcn"></i><span class="sr-only">Next</span></a>',
			dots: false,
			arrows: true,
			adaptiveHeight: true,
			speed: 800,
		});

		jQuery('.news-posts-carousel').slick({
			slidesToScroll: 1,
			rows: 0,
			slidesToShow: 2,
			arrows: false,
			dots: false,
			adaptiveHeight: true,
			speed: 800,

			responsive: [{
				breakpoint: 767,
				settings: {
					slidesToShow: 1
				}
			}]
		});

		jQuery('.news-posts-carousel2').slick({
			slidesToScroll: 1,
			rows: 0,
			slidesToShow: 3,
			arrows: false,
			dots: true,
			adaptiveHeight: true,
			speed: 800,

			responsive: [{
				breakpoint: 767,
				settings: {
					slidesToShow: 1
				}
			}]
		});

		jQuery('.news-posts-carousel3').slick({
			slidesToScroll: 1,
			rows: 0,
			slidesToShow: 2,
			prevArrow: '<a href="#" class="slick-prev"><i class="fi flaticon-arrows-1 readMoreIcn"></i><span class="sr-only">Previous</span></a>',
			nextArrow: '<a href="#" class="slick-next"><i class="fi flaticon-arrows readMoreIcn"></i><span class="sr-only">Next</span></a>',
			dots: false,
			arrows: true,
			adaptiveHeight: true,
			speed: 800,

			responsive: [{
				breakpoint: 767,
				settings: {
					slidesToShow: 1
				}
			}]
		});

		jQuery('.news-posts-carousel4').slick({
			slidesToScroll: 1,
			rows: 0,
			slidesToShow: 2,
			arrows: false,
			dots: true,
			adaptiveHeight: true,
			speed: 800,

			responsive: [{
				breakpoint: 767,
				settings: {
					slidesToShow: 1
				}
			}]
		});

		jQuery('.logos-slider').slick({
			slidesToScroll: 1,
			rows: 0,
			slidesToShow: 5,
			arrows: false,
			dots: false,
			adaptiveHeight: true,
			speed: 800,

			responsive: [{
				breakpoint: 991,
				settings: {
					slidesToShow: 3
				}
			},{
				breakpoint: 575,
				settings: {
					slidesToShow: 2
				}
			}]
		});

		jQuery('.bannerImageSlideshow').slick({
			slidesToScroll: 1,
			rows: 0,
			arrows: false,
			dots: true,
			dotsClass: 'switcherDotsVertical',
			fade: true,
			autoplay: true,
			autoplaySpeed: 10000,
			speed: 1500
		});
	}

	initCustomFormSlider();

	// custom collapse init
	function initCustomFormSlider() {

		"use strict"; 

		$(".span2").slider();
		$(".span2").on("slide", function(slideEvt) {
			var valueS = slideEvt.value;
			$(".startValue").text(valueS[0]);
			$(".endValue").text(valueS[1]);
		});
	}

	initCustomCollapse();

	// custom collapse init
	function initCustomCollapse() {

		"use strict";

		jQuery('body').bind('click', function(e) {
			if(jQuery(e.target).closest('.searchFormcollapse').length == 0) {
					// click happened outside of .navbar, so hide
					var opened = jQuery('.searchFormcollapse').hasClass('collapse in');
					if ( opened === true ) {
							jQuery('.searchFormcollapse').collapse('hide');
							jQuery('body').removeClass('searchIsActive');
					}
				}
		});

		jQuery('body').bind('click', function(e) {
			if(jQuery(e.target).closest('.navbar-collapse').length == 0) {
					// click happened outside of .navbar, so hide
					var opened = jQuery('.navbar-collapse').hasClass('collapse in');
					if ( opened === true ) {
							jQuery('.navbar-collapse').collapse('hide');
							jQuery('body').removeClass('menuIsActive');
					}
				}
		});

		jQuery('.navbar-toggle').on('click', function(){

			if(jQuery('body').hasClass('menuIsActive')){
				jQuery('body').removeClass('menuIsActive');
			} else{
				jQuery('body').addClass('menuIsActive');
			}
		});

		jQuery('.headerSearchForm .activeClassOnBody').on('click', function(){

			if(jQuery('body').hasClass('searchIsActive')){
				jQuery('body').removeClass('searchIsActive');
			} else{
				jQuery('body').addClass('searchIsActive');
			}
		});
	}

	initHoverClass();

	// add classes on hover/touch
	function initHoverClass() {

		"use strict"; 

		jQuery('.hasOver').touchHover();
	}

	initAnchors();

	// initialize smooth anchor links
	function initAnchors() {

		"use strict"; 

		new SmoothScroll({
			anchorLinks: 'a.smooth[href^="#"]:not([href="#"])',
			extraOffset: 0,
			wheelBehavior: 'none'
		});

		new SmoothScroll({
			anchorLinks: '.anchorNavigationList a[href^="#"]:not([href="#"])',
			extraOffset: function() {
				var totalHeight = 0;
				jQuery('.anchorNav').each(function() {
					var $box = jQuery(this);
					var stickyInstance = $box.data('StickyScrollBlock');
					if (stickyInstance) {
						stickyInstance.stickyFlag = false;
						stickyInstance.stickyOn();
						totalHeight += $box.outerHeight();
						stickyInstance.onResize();
					} else {
						totalHeight += $box.css('position') === 'fixed' ? $box.outerHeight() : 0;
					}
				});
				return totalHeight += 25;
			},
			activeClasses: 'parent',
			anchorActiveClass: 'active',
			wheelBehavior: 'none'
		});
	}

	initMobileNavigation();

	function initMobileNavigation() {

		"use strict";

		jQuery('#pageNav').mobileNavigation({
			slider:'.pageMainNav',
			nextLevel:'> .frame-wrap > .frame',
			title: '#menu-title'
		});
	}

	initTouchNav();

	// handle dropdowns on mobile devices
	function initTouchNav() {

		"use strict";

		jQuery('.pageMainNav').each(function() {
			new TouchNav({
				navBlock: this,
				menuDrop: '.frame-wrap'
			});
		});
	}

	initTabs();	
	// content tabs init
	function initTabs() {

		"use strict";
		
		jQuery('.tabset').tabset({
			tabLinks: 'a',
			addToParent: true,
			defaultTab: true
		});
		jQuery('.popupTabsetList').tabset({
			tabLinks: 'a',
			addToParent: true,
			defaultTab: true
		});
	}

	initStickyScrollBlock();

	// initialize fixed blocks on scroll
	function initStickyScrollBlock() {
		jQuery('.anchorNav').stickyScrollBlock({
			setBoxHeight: true,
			activeClass: 'fixed-position',
			container: '#main',
			positionType: 'fixed',
			extraTop: function() {
				var totalHeight = 0;
				jQuery('0').each(function() {
					totalHeight += jQuery(this).outerHeight();
				});
				return totalHeight;
			}
		});
	}
	
	initFancybox();
	// lightbox init
	function initFancybox() {
		jQuery('a.lightbox, [data-fancybox]').fancybox({
			parentEl: 'body',
			margin: [50, 0]
		});
	}


});



jQuery(window).on('load', function() {

	initIsoTop();

	// IsoTop init
	function initIsoTop() {
		"use strict";

		var isotopeHolder = jQuery('.isoContentHolder'),
			win = jQuery(window);
		jQuery('.isoFiltersList a').on( "click", function(e){
			e.preventDefault();
			
			jQuery('.isoFiltersList li').removeClass('active');
			jQuery(this).parent('li').addClass('active');
			var selector = jQuery(this).attr('data-filter');
			isotopeHolder.isotope({ filter: selector });
		});
		jQuery('.isoContentHolder').isotope({
			itemSelector: '.isoCol',
			transitionDuration: '0.6s',
			masonry: {
				columnWidth: '.isoCol'
			}
		});
	}

	initPreLoader();
	// PreLoader init
	function initPreLoader() {
	    "use strict";

	    jQuery('#loader').delay(1000).fadeOut();
	}

});


//javascript for hero section//


	function toggleAcresDropdown(id) {
		const dropdown = document.getElementById(id);
		const allDropdowns = document.querySelectorAll('.acres-dropdown-menu');
		
		allDropdowns.forEach(d => {
			if (d.id !== id) d.classList.remove('active');
		});
		
		dropdown.classList.toggle('active');
	}

	function selectCity(city) {
		document.querySelector('.acres-buy-btn').innerHTML = `Buy in ${city} ▼`;
		toggleAcresDropdown('city-dropdown');
		// Update search or redirect if needed
	}

	function selectProperty(type, value) {
		document.getElementById('property-type').textContent = type;
		document.getElementById('property-type-input').value = value;
		toggleAcresDropdown('property-dropdown');
	}

	function switchTab(element, tabName) {
		document.querySelectorAll('.acres-tab').forEach(t => t.classList.remove('active'));
		element.classList.add('active');
		// You can add tab-specific logic here
	}

	function fillSearchAcres(text) {
		document.getElementById('search-input').value = text;
	}

	function getLocationAcres() {
		if (navigator.geolocation) {
			navigator.geolocation.getCurrentPosition(function(position) {
				console.log('Location:', position.coords.latitude, position.coords.longitude);
				// You can use this to populate the search with nearby areas
			});
		}
	}

	function startVoiceSearchAcres() {
		if ('webkitSpeechRecognition' in window) {
			const recognition = new webkitSpeechRecognition();
			recognition.lang = 'en-IN';
			recognition.onresult = function(event) {
				document.getElementById('search-input').value = event.results[0][0].transcript;
			};
			recognition.start();
		} else {
			alert('Voice search not supported in this browser');
		}
	}

	function showAllSearchesAcres() {
		// Navigate to search history page or show modal
		console.log('Show all searches');
	}

	function toggleMobileMenu() {
		// Add mobile menu toggle logic
		const nav = document.querySelector('.acres-nav-menu');
		if (nav) {
			nav.style.display = nav.style.display === 'flex' ? 'none' : 'flex';
		}
	}

	// Close dropdowns when clicking outside
	document.addEventListener('click', (e) => {
		if (!e.target.closest('.acres-dropdown-select') && !e.target.closest('.acres-buy-dropdown')) {
			document.querySelectorAll('.acres-dropdown-menu').forEach(d => {
				d.classList.remove('active');
			});
		}
	});

	// Enter key search
	document.getElementById('search-input').addEventListener('keypress', (e) => {
		if (e.key === 'Enter') {
			e.preventDefault();
			document.getElementById('search-form').submit();
		}
	});
	
	//apartment===============and======villa//
	let currentPosition = 0;
        const slider = document.getElementById('slider');
        const cards = document.querySelectorAll('.card');
        const totalCards = cards.length;
        
        function getCardsPerView() {
            if (window.innerWidth <= 640) return 1;
            if (window.innerWidth <= 968) return 2;
            return 3;
        }

        function moveSlider(direction) {
            const cardsPerView = getCardsPerView();
            const maxPosition = totalCards - cardsPerView;
            
            currentPosition += direction;
            
            if (currentPosition < 0) {
                currentPosition = 0;
            } else if (currentPosition > maxPosition) {
                currentPosition = maxPosition;
            }
            
            const cardWidth = cards[0].offsetWidth;
            const gap = 30;
            const offset = -(currentPosition * (cardWidth + gap));
            
            slider.style.transform = `translateX(${offset}px)`;
        }

        // Handle window resize
        window.addEventListener('resize', () => {
            currentPosition = 0;
            slider.style.transform = 'translateX(0)';
        });

        // Optional: Auto-play slider
        let autoPlayInterval;
        
        function startAutoPlay() {
            autoPlayInterval = setInterval(() => {
                const cardsPerView = getCardsPerView();
                const maxPosition = totalCards - cardsPerView;
                
                if (currentPosition >= maxPosition) {
                    currentPosition = 0;
                    slider.style.transform = 'translateX(0)';
                } else {
                    moveSlider(1);
                }
            }, 4000);
        }

        function stopAutoPlay() {
            clearInterval(autoPlayInterval);
        }

        // Start auto-play
        startAutoPlay();

        // Pause on hover
        slider.addEventListener('mouseenter', stopAutoPlay);
        slider.addEventListener('mouseleave', startAutoPlay);

		//EMI=========Calcyulator========//
	
        function openTool(toolType) {
            const tools = {
                budget: 'Budget Calculator',
                emi: 'EMI Calculator',
                loan: 'Loan Eligibility Calculator',
                area: 'Area Converter'
            };
            alert(`Opening ${tools[toolType]}...`);
            // In a real application, this would navigate to the tool page
            // window.location.href = `/tools/${toolType}`;
        }

        function viewAllInsights() {
            alert('Viewing all insights...');
            // In a real application:
            // window.location.href = '/insights';
        }

        function scrollTools() {
            const container = document.getElementById('toolsContainer');
            const scrollAmount = 350;
            
            if (container.scrollLeft + container.clientWidth >= container.scrollWidth) {
                // If at the end, scroll back to start
                container.scrollTo({
                    left: 0,
                    behavior: 'smooth'
                });
            } else {
                // Otherwise scroll right
                container.scrollBy({
                    left: scrollAmount,
                    behavior: 'smooth'
                });
            }
        }

        // Add touch swipe support for mobile
        let touchstart = 0;
        let touchend = 0;

        const Container = document.getElementById('toolsContainer');

        container.addEventListener('touchstart', e => {
            touchStartX = e.changedTouches[0].screenX;
        });

        container.addEventListener('touchend', e => {
            touchEndX = e.changedTouches[0].screenX;
            handleSwipe();
        });

        function handleSwipe() {
            if (touchStartX - touchEndX > 50) {
                // Swiped left
                container.scrollBy({
                    left: 300,
                    behavior: 'smooth'
                });
            }
            
            if (touchEndX - touchStartX > 50) {
                // Swiped right
                container.scrollBy({
                    left: -300,
                    behavior: 'smooth'
                });
            }
        }

        // Add keyboard navigation
        document.addEventListener('keydown', (e) => {
            if (e.key === 'ArrowRight') {
                scrollTools();
            } else if (e.key === 'ArrowLeft') {
                container.scrollBy({
                    left: -350,
                    behavior: 'smooth'
                });
            }
        });
    

		 function scrollProjects(direction) {
            const container = document.getElementById('projectsContainer');
            const scrollAmount = 350;
            
            if (direction === 'left') {
                container.scrollBy({
                    left: -scrollAmount,
                    behavior: 'smooth'
                });
            } else {
                container.scrollBy({
                    left: scrollAmount,
                    behavior: 'smooth'
                });
            }
        }

        function toggleFavorite(event) {
            event.stopPropagation();
            const btn = event.currentTarget;
            btn.classList.toggle('active');
        }

        // Add touch swipe support for mobile
        let touchStartX = 0;
        let touchEndX = 0;

        const container = document.getElementById('projectsContainer');

        container.addEventListener('touchstart', e => {
            touchStartX = e.changedTouches[0].screenX;
        });

        container.addEventListener('touchend', e => {
            touchEndX = e.changedTouches[0].screenX;
            handleSwipe();
        });

        function handleSwipe() {
            if (touchStartX - touchEndX > 50) {
                scrollProjects('right');
            }
            
            if (touchEndX - touchStartX > 50) {
                scrollProjects('left');
            }
        }

        // Keyboard navigation
        document.addEventListener('keydown', (e) => {
            if (e.key === 'ArrowRight') {
                scrollProjects('right');
            } else if (e.key === 'ArrowLeft') {
                scrollProjects('left');
            }
        });

        // Add click handler to project cards
        document.querySelectorAll('.project-card').forEach(card => {
            card.addEventListener('click', function(e) {
                if (!e.target.classList.contains('favorite-btn')) {
                    const projectName = this.querySelector('.project-name').textContent;
                    console.log(`Opening project: ${projectName}`);
                    // In real application: window.location.href = '/project/' + projectId;
                }
            });
        });
    